in vec2 texCoord;

uniform sampler2D colorMap;
uniform sampler2D pic1;
uniform sampler2D pic2;

uniform float time;

uniform vec4 glColor;



void main (void)
{

vec4 col;

		/// fadein alpha masked
		col = texture2D(colorMap, texCoord);
		vec4 col2 = texture2D(pic1, texCoord);
		float time2 = clamp(time*2.0,0.0,1.0);
		float alpha = col2.a*time2;
		col = mix(col,col2,alpha);

		/// fadein full over it
		if (time>0.5){
			vec4 col2 = texture2D(pic2, texCoord);
			float time2 = clamp((time-0.5)*2.5,0.0,1.0);
			float alpha = col2.a*time2;
			col = mix(col,col2,alpha);
		}

		if (time>2.5){ /// fadeout
			vec4 col2 = texture2D(colorMap, texCoord);
			float time2 = clamp((time-2.5)*2.5,0.0,1.0);
			float alpha = col2.a*time2;
			col = mix(col,col2,alpha);
		}

	gl_FragColor = col;
}
